program dotNetApp;

uses
  Borland.Win32.Windows,
  System.Text,
  System.Windows.Forms;

type
  TfrmPInvoke = class(Form)
    btnUserName: Button;
    btnComputerName: Button;
    btnWindowsDir: Button;
    btnSystemDir: Button;
    btnCurrentDir: Button;
    procedure btnUserNameClick(Sender: TObject; Args: EventArgs);
    procedure btnComputerNameClick(Sender: TObject; Args: EventArgs);
    procedure btnWindowsDirClick(Sender: TObject; Args: EventArgs);
    procedure btnSystemDirClick(Sender: TObject; Args: EventArgs);
    procedure btnCurrentDirClick(Sender: TObject; Args: EventArgs);
  public
    constructor Create;
  end;

{ TfrmPInvoke }

constructor TfrmPInvoke.Create;
begin
  inherited;
  Width := 776;
  Height := 90;
  StartPosition := FormStartPosition.CenterScreen;
  Text := '.NET App Using Win32 String Routines';
  FormBorderStyle := FormBorderStyle.FixedSingle;
  MinimizeBox := False;
  MaximizeBox := False;
  btnUserName := Button.Create;
  with btnUserName do
  begin
    Text := 'User Name';
    SetBounds(16, 16, 137, 33);
    Parent := Self;
    Add_Click(btnUserNameClick);
  end;
  btnComputerName := Button.Create;
  with btnComputerName do
  begin
    Text := 'Computer Name';
    SetBounds(168, 16, 137, 33);
    Parent := Self;
    Add_Click(btnComputerNameClick);
  end;
  btnWindowsDir := Button.Create;
  with btnWindowsDir do
  begin
    Text := 'Windows Dir';
    SetBounds(320, 16, 137, 33);
    Parent := Self;
    Add_Click(btnWindowsDirClick);
  end;
  btnSystemDir := Button.Create;
  with btnSystemDir do
  begin
    Text := 'System Dir';
    SetBounds(472, 16, 137, 33);
    Parent := Self;
    Add_Click(btnSystemDirClick);
  end;
  btnCurrentDir := Button.Create;
  with btnCurrentDir do
  begin
    Text := 'Current Dir';
    SetBounds(624, 16, 137, 33);
    Parent := Self;
    Add_Click(btnCurrentDirClick);
  end;
end;

procedure TfrmPInvoke.btnUserNameClick(Sender: TObject; Args: EventArgs);
var
  UserBuf: StringBuilder;
  UserBufLen: DWord;
begin
  UserBuf := StringBuilder.Create(64);
  UserBufLen := UserBuf.Capacity;
  if GetUserName(UserBuf, UserBufLen) then
    MessageBox.Show(UserBuf.ToString)
  else
    //User name is longer than 64 characters
end;

procedure TfrmPInvoke.btnComputerNameClick(Sender: TObject; Args: EventArgs);
var
  ComputerBuf: StringBuilder;
  ComputerBufLen: DWord;
begin
  //Set max size buffer to ensure success
  ComputerBuf := StringBuilder.Create(MAX_COMPUTERNAME_LENGTH);
  ComputerBufLen := ComputerBuf.Capacity;
  if GetComputerName(ComputerBuf, ComputerBufLen) then
    MessageBox.Show(ComputerBuf.ToString)
end;

procedure TfrmPInvoke.btnWindowsDirClick(Sender: TObject; Args: EventArgs);
var
  WinDirBuf: StringBuilder;
begin
  WinDirBuf := StringBuilder.Create(MAX_PATH); //Set max size buffer to ensure success
  GetWindowsDirectory(WinDirBuf, WinDirBuf.Capacity);
  MessageBox.Show(WinDirBuf.ToString)
end;

procedure TfrmPInvoke.btnSystemDirClick(Sender: TObject; Args: EventArgs);
var
  SysDirBuf: StringBuilder;
begin
  SysDirBuf := StringBuilder.Create(MAX_PATH); //Set max size buffer to ensure success
  GetSystemDirectory(SysDirBuf, SysDirBuf.Capacity);
  MessageBox.Show(SysDirBuf.ToString)
end;

procedure TfrmPInvoke.btnCurrentDirClick(Sender: TObject; Args: EventArgs);
var
  CurrDirBuf: StringBuilder;
begin
  CurrDirBuf := StringBuilder.Create(MAX_PATH); //Set max size buffer to ensure success
  GetCurrentDirectory(CurrDirBuf.Capacity, CurrDirBuf);
  MessageBox.Show(CurrDirBuf.ToString)
end;

begin
  Application.Run(TfrmPInvoke.Create);
end.
